
local assdraw = require 'mp.assdraw'
local msg = require 'mp.msg'
function draw_position_text(ass, text, position, window_size, offset)
    ass:new_event()
    local align = 1
    local ofx = 1
    local ofy = -1
    if position.x > window_size.w / 2 then
        align = align + 2
        ofx = -1
    end
    if position.y < window_size.h / 2 then
        align = align + 6
        ofy = 1
    end
    ass:append("{\\an"..align.."}")
    ass:append("{\\fs26}")
    ass:append("{\\bord1.5}")
    ass:pos(ofx*offset + position.x, ofy*offset + position.y)
    ass:append(text)

    mp.set_osd_ass(window_size.w, window_size.h, ass.text)
end

function draw_crosshair(ass, center, window_size)
    ass:new_event()
    ass:pos(0, 0)
    ass:append("{\\an7}")
    ass:append("{\\bord0}")
    ass:append("{\\shad0}")
    ass:append("{\\c&HBBBBBB&}")
    ass:append("{\\1a&H00&}")
    ass:append("{\\2a&HFF&}")
    ass:append("{\\3a&HFF&}")
    ass:append("{\\4a&HFF&}")
    ass:draw_start()
    ass:rect_cw(center.x - 0.5, 0, center.x + 0.5, window_size.h)
    ass:rect_cw(0, center.y - 0.5, window_size.w, center.y + 0.5)
    ass:draw_stop()
end
function draw_frame(ass, frame)
    ass:new_event()
    ass:pos(0, 0)
    ass:append("{\\an7}")
    ass:append("{\\bord0}")
    ass:append("{\\shad0}")
    ass:append("{\\c&H" .. opts.frame_border_color .. "&}")
    ass:append("{\\1a&H00&}")
    ass:append("{\\2a&HFF&}")
    ass:append("{\\3a&HFF&}")
    ass:append("{\\4a&HFF&}")
    local c1, c2 = frame.top_left, frame.bottom_right
    local b = opts.frame_border_width
    ass:draw_start()
    ass:rect_cw(c1.x, c1.y - b, c2.x + b, c1.y)
    ass:rect_cw(c2.x, c1.y, c2.x + b, c2.y + b)
    ass:rect_cw(c1.x - b, c2.y, c2.x, c2.y + b)
    ass:rect_cw(c1.x - b, c1.y - b, c1.x, c2.y)
    ass:draw_stop()
end
function draw_box()
    local ass = assdraw.ass_new()
    msg.log('info','here')
    local dim  = { w = 100, h =100 }
    draw_position_text(ass, "test here!", {x=50,y=50},dim, 6)
    draw_crosshair(ass, {x=50,y=50}, dim)

    mp.set_osd_ass(dim.w, dim.h, ass.text)
end
function clear_box()
    mp.set_osd_ass(1280, 720, '')
end
mp.add_key_binding(nil, "draw-box", draw_box)
mp.add_key_binding(nil, "clear-box", clear_box)
